ifndef _CSmiley_
_CSmiley_ equ 1

; --=====================================================================================--
; #CLASS:    CSmiley
; #VERSION:  1.0
; --=====================================================================================--
; Built by NaN's Object Class Creator
;  Sept 19, 2001
;
; By Thomas Bleeker 
;
; --=====================================================================================--
; #AUTHOR: Thomas Bleeker 
; #DATE:   Sept. 20, 2001
;
; #DESCRIPTION:
;
;          This is the CSmiley Object class.  It will INHERIT all the properties and 
;          methods from the CSprite class, thus CSprite.asm must be included into the project.
;          <br><br>CSmiley will then extend this basis by providing extra methods to work
;          on the inherited properties, they are enableSteps() and setStepsDC().  As well
;          since new features are added to the base class (via inheritance), this class will
;          also provide a "polymorphic" draw method.  This means that when a CSmiley object is
;          told to do its "draw" method, this new method function will be called upon, however,
;          if a CSprite class is called to do its "draw" method, the origional "draw" will be
;          called upon (This is the essence of Polymorphism)..
;
; --=====================================================================================--
; CLASS METHOD PROTOS
; --=====================================================================================--
   CSmiley_Init    PROTO :DWORD

; --=====================================================================================--
; FUNCTION POINTER PROTOS
; --=====================================================================================--
   CSmiley_destructorPto    TYPEDEF  PROTO  :DWORD 
   CSmiley_enableStepsPto	TYPEDEF	 PROTO	:DWORD, :DWORD
   CSmiley_setStepsDCPto	TYPEDEF	 PROTO	:DWORD, :DWORD
   CSmiley_drawPto			TYPEDEF	 PROTO  :DWORD
; --=====================================================================================--
; CLASS STRUCTURE
; --=====================================================================================--
   CLASS CSmiley
   	  ; inherited class!
   	  CSprite		<>
   	  ; other methods:
      CMETHOD		enableSteps
      CMETHOD		setStepsDC
      ; varibles:
      fStepsEnabled	dd	?		;set if steps are on
      dcSteps		dd	?
      hStepsBitmap	dd	?
      dcStepsBitmap	dd	?
   CSmiley ENDS

.data

   BEGIN_INIT 
      dd offset CSmiley_destructor
      dd offset CSmiley_enableSteps
      dd offset CSmiley_setStepsDC
      dd 0		;fStepsEnabled, 0 by default
      dd 0		;dcSteps
      dd 0		;hStepsBitmap
      dd 0		;dcStepsBitmap
   END_INIT


.code
; --=====================================================================================--
; #METHOD:      CONSTRUCTOR (NONE)
;
; #DESCRIPTION: Basic constructor setup as well as inheriting from CSprite and providing 
;               polymorphism for the "draw" method.  As well the constructor will set each
;               instance up with a DC to hold footprints and load the graphic into it.  
;               This is the basic purpose demostrated by inheriting the base CSprite class
;               and appending extra freatures to it (foot prints in this case)..
;
; #RETURN:      Nothing..
; --=====================================================================================--
CSmiley_Init  PROC uses edi esi lpTHIS:DWORD
   SET_CLASS CSmiley INHERITS CSprite
   SetObject edi, CSmiley
	
   OVERRIDE	  draw, CSmiley_draw               ; Polymorphic action is taken on the draw method.
   invoke	  GetModuleHandle, 0
   invoke	  LoadBitmap, eax, 300
   mov		  [edi].hStepsBitmap, eax
   invoke	  CreateCompatibleDC, NULL
   mov		  [edi].dcStepsBitmap, eax
   invoke	  SelectObject, eax, [edi].hStepsBitmap
   

   ReleaseObject edi
   ret
CSmiley_Init ENDP

; --=====================================================================================--
; #METHOD:      destructor (NONE)
;
; #DESCRIPTION: Will delete the object extra footprint bitmap and the extra DC created for 
;               this object.  As well it will then call the SUPER class (CSprite) which this
;               class is inherited from and call its DESTRUCTOR method to do all the extra
;               clean up it provides for its base properties..
;
; #RETURN:      Nothing..
; --=====================================================================================--
CSmiley_destructor  PROC uses edi lpTHIS:DWORD 
   SetObject edi, CSmiley

   mov eax, [edi].dcStepsBitmap
   .IF	eax
   		invoke	DeleteDC, eax
   .ENDIF
   
   mov eax, [edi].hStepsBitmap
   .IF eax
   		invoke	DeleteObject, eax
   .ENDIF

   SUPER	destructor 

   ReleaseObject edi
   ret
CSmiley_destructor  ENDP

; --=====================================================================================--
; #METHOD:      draw (VOID)
;
; #DESCRIPTION: This is the polymorphic draw method specific to CSmiley object instnaces. 
;               It re-uses the inherited "draw" code form the base class it inherits from (CSprite),
;               and then does some "extra" functionality to draw footprints as well, provided
;               that that Steps has been enabled for the CSmiley objects instance..
;
; #RETURN:      Nothing..
; --=====================================================================================--
CSmiley_draw  PROC uses edi lpTHIS:DWORD
   SetObject edi, CSmiley
 
   SUPER	draw                               ; << First do CSprite.draw() method !!!
   
   ; Now, if enabled, draw the footprints as well around this character.
   .IF		[edi].fStepsEnabled
	   invoke	RAND32, 3
	   shl		eax, 4 ; * 16 pixels
	   
	
	   invoke	BitBlt, [edi].dcSteps, [edi].xPos, [edi].yPos, \	
						16, 16, [edi].dcStepsBitmap, eax, 0, SRCAND	
   .ENDIF
   ReleaseObject edi
   ret
CSmiley_draw ENDP
   
; --=====================================================================================--
; #METHOD:      setStepsDC (hDC)
;
; #DESCRIPTION: Used to set the DC for the footprint graphics for this object..
;
; #PARAM:       hDC    The DC the footprint graphics are to be saved to..
;
; #RETURN:      Nothing..
; --=====================================================================================--
CSmiley_setStepsDC  PROC uses edi lpTHIS:DWORD, hDC:DWORD
   SetObject edi, CSmiley
   mov 	eax, hDC
   mov	[edi].dcSteps, eax
   
   ReleaseObject edi
   ret
CSmiley_setStepsDC ENDP

; --=====================================================================================--
; #METHOD:      enableSteps (flag)
;
; #DESCRIPTION: Used to set each instance to show or not show footprints when drawn with
;               the polymorphic draw method (by calling draw upon a CSmiley class instance)..
;
; #PARAM:       flag    True, the footprints are drawn, FLASE, they are not..
;
; #RETURN:      Nothing..
; --=====================================================================================--
CSmiley_enableSteps  PROC uses edi lpTHIS:DWORD, flag:DWORD
   SetObject edi, CSmiley
   mov 	eax, flag
   mov	[edi].fStepsEnabled, eax
   
   ReleaseObject edi
   ret
CSmiley_enableSteps ENDP

 
endif